/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_11; import java.util.*; 
import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import lotus.domino.*;

/**
 * Allgemeine Demo fr RichText Funktionen in Domino
 * @author Thomas Ekert
 */
public class RichTextDemo extends NotesThread {

	private static final String PASSWORD = "geheim";
	private static final String HOST = null;//"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null;//"Thomas Ekert/DJBUCH";	//null fr lokale Session

	private static View view = null;
	public static void main(String[] args) {
		RichTextDemo rtd = new RichTextDemo();
		rtd.start();
	}
	public void runNotes() {
		Document doc = null;
		Database db = null;
		Session session = null;
		RichTextItem rti = null;
		RichTextItem otherRTItem = null;
		RichTextNavigator rtNavigator = null;
		RichTextParagraphStyle rtparagraphstyle = null;
		RichTextRange rtrange = null;
		RichTextSection rtsection = null;
		RichTextStyle rtstyle = null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase("", "djbuch/djbuch.nsf");
			view = db.getView("V_viewRichText_k11");
			doc = DemoTools.createDoc(db,"FO_dokumentRT_k11", "Wombat","Ich beinhalte RichText", null);
			rti = doc.createRichTextItem("body");
			
			//insert some Text, NewLines and Tabs
			rti.appendText("1" + DUMMY_TEXT);			
			rti.addNewLine(1);
			rti.appendText("2" + DUMMY_TEXT);
			rti.addNewLine(1,false);
			rti.addTab(2);
			rti.appendText("3" + DUMMY_TEXT);
			rti.addNewLine(1);
			rtstyle = session.createRichTextStyle();
			rtstyle.setBold(1);
			rti.appendStyle(rtstyle);
			rti.appendText("4" + DUMMY_TEXT);
			rtstyle.setBold(0);
			rtstyle.setFont(RichTextStyle.FONT_COURIER);
			rti.appendStyle(rtstyle);
			
			//Insert some Doclinks in the middle of the RichText using beginInsert
			rtNavigator = rti.createNavigator();
			rtNavigator.findFirstElement(RichTextItem.RTELEM_TYPE_TEXTPARAGRAPH);
			rtNavigator.findNextElement();
			rti.beginInsert(rtNavigator,true);
			rti.appendText("zwischendrin");
			rti.addNewLine(); rti.appendText("Link zum Dokument: ");
			rti.appendDocLink(doc, "Link zum Dokument");
			rti.addNewLine(); rti.appendText("Link zur Datenbank: ");
			rti.appendDocLink(db, "Link zur Datenbank");
			rti.addNewLine(); rti.appendText("Link zum View: ");
			rti.appendDocLink(view, "Link zum View");
			rti.addNewLine(); rti.appendText("Link zum View: ");
			rti.appendDocLink(view,"MouseOverText","Link Text");

			//Insert a Table using paragraphstyles
			rtparagraphstyle = session.createRichTextParagraphStyle();
			rtparagraphstyle.setSpacingAbove(RichTextParagraphStyle.SPACING_DOUBLE);
			rtparagraphstyle.setLeftMargin((int)(RichTextParagraphStyle.RULER_ONE_CENTIMETER*0.4));
			rtparagraphstyle
					.setFirstLineLeftMargin((int) (RichTextParagraphStyle.RULER_ONE_CENTIMETER * 0.4));
			rtparagraphstyle.setRightMargin((int)(RichTextParagraphStyle.RULER_ONE_CENTIMETER*6));
			rtparagraphstyle.setAlignment(RichTextParagraphStyle.ALIGN_FULL); 
			Vector labels = new Vector();
			Vector styles = new Vector();
			int columns = 4;
			int rows = 3;
			for (int i = 0; i<columns; i++) styles.add (rtparagraphstyle);
			for (int i = 0; i<rows; i++) labels.add ("Row"+i);
			rti.appendTable(rows, columns, labels,
					(int) (RichTextParagraphStyle.RULER_ONE_CENTIMETER * 5.6),
					styles);

			//Insert a Section
			rtstyle.setBold(1); rtstyle.setItalic(1);
			ColorObject co = session.createColorObject();
			co.setRGB(255,125,0);
			rti.beginSection("1234567890Neuer Abschnitt", rtstyle, co, false);
			rti.appendText("Text im Abschnitt.");
			rti.endSection();
			rti.beginSection("1234567890Neuer Abschnitt2", rtstyle, co, false);
			rti.appendText("2ter Text im Abschnitt.");
			rti.endSection();
			
			//Append a new Page
			rti.endInsert();
			rtparagraphstyle
					.setLeftMargin((int) (RichTextParagraphStyle.RULER_ONE_CENTIMETER * 3.4));
			rtparagraphstyle
					.setFirstLineLeftMargin((int) (RichTextParagraphStyle.RULER_ONE_CENTIMETER * 2.8));
			rti.addPageBreak(rtparagraphstyle);
			rti.appendText ("Neue Seite. " + DUMMY_TEXT + DUMMY_TEXT);

			//Append another RichTextItem
			otherRTItem = doc.createRichTextItem("F_otherRTItem");
			otherRTItem.addNewLine();
			otherRTItem.appendText("Inhalt des anderen RT Items");
			otherRTItem.addNewLine();
			rti.appendRTItem(otherRTItem);
			
			//Some Navigation
			rti.update();
			if (!rtNavigator.findFirstElement(RichTextItem.RTELEM_TYPE_SECTION)) return;
			do {
				rtsection = (RichTextSection)rtNavigator.getElement();
				//System.out.println (rtsection.getBarColor().getGreen());
			} while (rtNavigator.findNextElement(RichTextItem.RTELEM_TYPE_SECTION));

			//String Search
			System.out.println ("Text \"Link\" wurde gefunden: " + rtNavigator.findFirstString("Link"));
			System.out.println ("Text \"Link\" wurde erneut gefunden: " + rtNavigator.findNextString("Link"));
			rtNavigator.setCharOffset(3);
			rtrange = rti.createRange();
			rtrange.setBegin(rtNavigator);
			System.out.println ("(Teil-)Text nach Offset Verschiebung: " + rtrange.getTextParagraph());
			rtrange = rti.createRange();
			rtNavigator = rti.createNavigator();
			rtNavigator.findFirstElement(RichTextItem.RTELEM_TYPE_TEXTRUN);
			//rtNavigator.findNextElement(RichTextItem.RTELEM_TYPE_TEXTRUN,4);
			rtrange.setBegin(rtNavigator);
			rtNavigator.findFirstElement(RichTextItem.RTELEM_TYPE_TEXTRUN);
			rtrange.setEnd(rtNavigator);
			rtrange.setStyle(rtstyle);
			System.out.println ("Twip pro INCH " + (int) (2.54*RichTextParagraphStyle.RULER_ONE_CENTIMETER));
			rtparagraphstyle = session.createRichTextParagraphStyle();
			rtparagraphstyle
					.setRightMargin((int) (25.4 * RichTextParagraphStyle.RULER_ONE_CENTIMETER));
			rtparagraphstyle.setTab(
					5 * RichTextParagraphStyle.RULER_ONE_CENTIMETER,
					RichTextParagraphStyle.TAB_LEFT);
			rtparagraphstyle.setTab(
					10 * RichTextParagraphStyle.RULER_ONE_CENTIMETER,
					RichTextParagraphStyle.TAB_LEFT);
			rti.addPageBreak(rtparagraphstyle);
			rti.appendText("Pos1");
			rti.addTab();
			rti.appendText("Pos2");
			rti.addTab();
			rti.appendText("Pos3");
			rti.addNewLine();
			rtstyle=session.createRichTextStyle();
			rtstyle.setBold(RichTextStyle.YES);
			rti.appendStyle(rtstyle);
			rti.appendText("bold ");
			rtstyle=session.createRichTextStyle();
			rtstyle.setItalic(RichTextStyle.YES);
			rti.appendStyle(rtstyle);
			rti.appendText("boldAndItalic ");
			rtstyle.setBold(RichTextStyle.NO);
			rti.appendStyle(rtstyle);
			rti.appendText("onlyItalic ");
			rtstyle.setItalic(RichTextStyle.NO);
			rti.appendStyle(rtstyle);
			rti.appendText("plain");
			
			doc.save (true,false);
			GC.recycle (doc);
			System.out.println ("...done.\n\n\nDas neu erstellte Dokument finden Sie in der Ansicht Kapitel 11\\RichText");
		} catch (Exception e) {
			e.printStackTrace();
			System.err.println ((e instanceof NotesException?"id = " +((NotesException)e).id:""));
		} finally {
			GC.recycle (rti);
			GC.recycle (otherRTItem);
			GC.recycle (rtNavigator);
			GC.recycle (rtparagraphstyle);
			GC.recycle (rtrange);
			GC.recycle (rtsection);
			GC.recycle (rtstyle);
			GC.recycle(doc);
			GC.recycle(view);
			GC.recycle(db);
			GC.recycle(session);
		}
		
	}
	
	private static final String DUMMY_TEXT = "The quick brown fox jumped over the lazy dog.";
}
